#!/usr/bin/env bash

echo -e "\nSourcing app.env\n"
source ./nextgen/app.env

echo -e "\nSourcing set-dev-env.sh\n"
source ./nextgen/set-dev-env.sh

START_NEXTGEN_STACK=${1:-false}

# Start the nextgen stack if requested
if [[ $START_NEXTGEN_STACK = true ]]; then
    echo -e "\nStarting nextgen-stack"
    export TAIL_LOGS=false
    pushd ../nextgen-stack
    ./run-all.sh
    popd
fi

echo -e "\nSourcing nextgen-stack/set-dev-envars.sh\n"
source ../nextgen-stack/set-dev-envars.sh

echo -e "\nCompile VA FitHeart Front-End code\n"
./nextgen/build.sh || { echo "FATAL: Failed to build VA FitHeart Front-End"; exit 1; }

./nextgen/stop-dev.sh

echo -e "\nSetting needed environment variables in Consul"
./nextgen/set-consul-vars.sh || { echo "FATAL: Failed to set needed environment variables in Consul. Make sure Consul is running"; exit 1; }

echo -e "\nStart VA FitHeart containers\n"
docker-compose -f ./nextgen/docker-compose-dev.yml up -d --build || { echo "FATAL: Failed to start the VA FitHeart containers. error $?"; exit 1; }

echo -e "\nRegister VA FitHeart application services with Consul"
./nextgen/register_services.sh || { echo "FATAL: Failed to register the VA FitHeart application services with Consul. Make sure Consul is running"; exit 1; }
